--- dcmnet/libsrc/dulfsm.cc.orig	2010-12-01 08:26:36 UTC
+++ dcmnet/libsrc/dulfsm.cc
@@ -920,7 +920,7 @@ AE_3_AssociateConfirmationAccept(PRIVATE
             userPresentationCtx = (DUL_PRESENTATIONCONTEXT*)malloc(sizeof(DUL_PRESENTATIONCONTEXT));
             if (userPresentationCtx == NULL) return EC_MemoryExhausted;
 
-            (void) memset(userPresentationCtx, 0, sizeof(userPresentationCtx));
+            (void) memset(userPresentationCtx, 0, sizeof(*userPresentationCtx));
             userPresentationCtx->result = prvCtx->result;
             userPresentationCtx->presentationContextID = prvCtx->contextID;
             userPresentationCtx->proposedTransferSyntax = NULL;
@@ -3738,16 +3738,17 @@ setTCPBufferLength(int sock)
         if (sscanf(TCPBufferLength, "%d", &bufLen) != 1)
         {
             DCMNET_WARN("DULFSM: cannot parse environment variable TCP_BUFFER_LENGTH=" << TCPBufferLength);
-        }
-    }
+        } else {
 #if defined(SO_SNDBUF) && defined(SO_RCVBUF)
-    (void) setsockopt(sock, SOL_SOCKET, SO_SNDBUF, (char *) &bufLen, sizeof(bufLen));
-    (void) setsockopt(sock, SOL_SOCKET, SO_RCVBUF, (char *) &bufLen, sizeof(bufLen));
+	    (void) setsockopt(sock, SOL_SOCKET, SO_SNDBUF, (char *) &bufLen, sizeof(bufLen));
+	    (void) setsockopt(sock, SOL_SOCKET, SO_RCVBUF, (char *) &bufLen, sizeof(bufLen));
 #else
-     DCMNET_WARN("DULFSM: setTCPBufferLength: "
-            "cannot set TCP buffer length socket option: "
-            "code disabled because SO_SNDBUF and SO_RCVBUF constants are unknown");
+	     DCMNET_WARN("DULFSM: setTCPBufferLength: "
+		    "cannot set TCP buffer length socket option: "
+		    "code disabled because SO_SNDBUF and SO_RCVBUF constants are unknown");
 #endif // SO_SNDBUF and SO_RCVBUF
+	}
+    }
 #endif // HAVE_GUSI_H
 }
 
