--- dcmnet/libsrc/dul.cc.orig	2010-12-01 08:26:36 UTC
+++ dcmnet/libsrc/dul.cc
@@ -2328,16 +2328,17 @@ setTCPBufferLength(int sock)
     if ((TCPBufferLength = getenv("TCP_BUFFER_LENGTH")) != NULL) {
         if (sscanf(TCPBufferLength, "%d", &bufLen) != 1) {
             DCMNET_WARN("DUL: cannot parse environment variable TCP_BUFFER_LENGTH=" << TCPBufferLength);
-        }
-    }
+        }else{
 #if defined(SO_SNDBUF) && defined(SO_RCVBUF)
-    (void) setsockopt(sock, SOL_SOCKET, SO_SNDBUF, (char *) &bufLen, sizeof(bufLen));
-    (void) setsockopt(sock, SOL_SOCKET, SO_RCVBUF, (char *) &bufLen, sizeof(bufLen));
+	    (void) setsockopt(sock, SOL_SOCKET, SO_SNDBUF, (char *) &bufLen, sizeof(bufLen));
+	    (void) setsockopt(sock, SOL_SOCKET, SO_RCVBUF, (char *) &bufLen, sizeof(bufLen));
 #else
-    DCMNET_WARN("DULFSM: setTCPBufferLength: "
-        "cannot set TCP buffer length socket option: "
-        "code disabled because SO_SNDBUF and SO_RCVBUF constants are unknown");
+	    DCMNET_WARN("DULFSM: setTCPBufferLength: "
+		"cannot set TCP buffer length socket option: "
+		"code disabled because SO_SNDBUF and SO_RCVBUF constants are unknown");
 #endif // SO_SNDBUF and SO_RCVBUF
+	}
+    }
 #endif // HAVE_GUSI_H
 }
 
