#include "dcmtk/config/osconfig.h" /* make sure OS specific
configuration is included first */

#include "dcmtk/dcmdata/dctk.h"
#include <pthread.h>

#ifndef NTHREADS
#define NTHREADS 32
#endif

static void* run(void* arg) {
  const char* filename = static_cast<const char*>(arg);

  const char utf8_charset[] = "ISO_IR 192";
  const E_FileReadMode opt_readMode = ERM_autoDetect;
  const E_TransferSyntax opt_ixfer = EXS_Unknown;

  DcmFileFormat fileformat;
  OFCondition error = fileformat.loadFile(filename, opt_ixfer, EGL_noChange,
                                          DCM_MaxReadLength, opt_readMode);
  assert(error.good());
  DcmDataset* dataset = fileformat.getDataset();

  const size_t opt_conversionFlags = 0;
  const OFString toCharset(utf8_charset);

  error = dataset->convertCharacterSet(toCharset, opt_conversionFlags);

  return nullptr;
}

int main(int argc, char* argv[]) {
  if (argc < 2) {
    return 1;
  }
  const char* filename = argv[1];

  int rc;
  pthread_t threads[NTHREADS];
  for (int i = 0; i < NTHREADS; ++i) {
    if (rc = pthread_create(threads + i, nullptr, run, (void*)filename)) {
      return 1;
    }
  }

  for (int i = 0; i < NTHREADS; ++i) {
    if (rc = pthread_join(threads[i], nullptr)) {
      return 1;
    }
  }

  return 0;
}
