#! /usr/bin/perl

$map = 2;
$table = sprintf("UCS%%ISO-8859-%d.src", $map);

@iso8859_2_to_unicode = (
    "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F",
    "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F",
    "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F",
    "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F",
    "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F",
    "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F",
    "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F",
    "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F",
    "0080", "0081", "0082", "0083", "0084", "0085", "0086", "0087", "0088", "0089", "008A", "008B", "008C", "008D", "008E", "008F", 
    "0090", "0091", "0092", "0093", "0094", "0095", "0096", "0097", "0098", "0099", "009A", "009B", "009C", "009D", "009E", "009F", 
    "00A0", "0104", "02D8", "0141", "00A4", "013D", "015A", "00A7", "00A8", "0160", "015E", "0164", "0179", "00AD", "017D", "017B", 
    "00B0", "0105", "02DB", "0142", "00B4", "013E", "015B", "02C7", "00B8", "0161", "015F", "0165", "017A", "02DD", "017E", "017C", 
    "0154", "00C1", "00C2", "0102", "00C4", "0139", "0106", "00C7", "010C", "00C9", "0118", "00CB", "011A", "00CD", "00CE", "010E", 
    "0110", "0143", "0147", "00D3", "00D4", "0150", "00D6", "00D7", "0158", "016E", "00DA", "0170", "00DC", "00DD", "0162", "00DF", 
    "0155", "00E1", "00E2", "0103", "00E4", "013A", "0107", "00E7", "010D", "00E9", "0119", "00EB", "011B", "00ED", "00EE", "010F", 
    "0111", "0144", "0148", "00F3", "00F4", "0151", "00F6", "00F7", "0159", "016F", "00FA", "0171", "00FC", "00FD", "0163", "02D9");

@iso8859_3_to_unicode = (
    "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F",
    "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F",
    "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F",
    "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F",
    "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F",
    "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F",
    "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F",
    "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F",
    "0080", "0081", "0082", "0083", "0084", "0085", "0086", "0087", "0088", "0089", "008A", "008B", "008C", "008D", "008E", "008F", 
    "0090", "0091", "0092", "0093", "0094", "0095", "0096", "0097", "0098", "0099", "009A", "009B", "009C", "009D", "009E", "009F", 
    "00A0", "0126", "02D8", "00A3", "00A4", "FFFE", "0124", "00A7", "00A8", "0130", "015E", "011E", "0134", "00AD", "FFFE", "017B", 
    "00B0", "0127", "00B2", "00B3", "00B4", "00B5", "0125", "00B7", "00B8", "0131", "015F", "011F", "0135", "00BD", "FFFE", "017C", 
    "00C0", "00C1", "00C2", "FFFE", "00C4", "010A", "0108", "00C7", "00C8", "00C9", "00CA", "00CB", "00CC", "00CD", "00CE", "00CF", 
    "FFFE", "00D1", "00D2", "00D3", "00D4", "0120", "00D6", "00D7", "011C", "00D9", "00DA", "00DB", "00DC", "016C", "015C", "00DF", 
    "00E0", "00E1", "00E2", "FFFE", "00E4", "010B", "0109", "00E7", "00E8", "00E9", "00EA", "00EB", "00EC", "00ED", "00EE", "00EF", 
    "FFFE", "00F1", "00F2", "00F3", "00F4", "0121", "00F6", "00F7", "011D", "00F9", "00FA", "00FB", "00FC", "016D", "015D", "02D9");

@iso8859_4_to_unicode = (
    "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F",
    "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F",
    "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F",
    "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F",
    "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F",
    "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F",
    "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F",
    "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F",
    "0080", "0081", "0082", "0083", "0084", "0085", "0086", "0087", "0088", "0089", "008A", "008B", "008C", "008D", "008E", "008F", 
    "0090", "0091", "0092", "0093", "0094", "0095", "0096", "0097", "0098", "0099", "009A", "009B", "009C", "009D", "009E", "009F", 
    "00A0", "0104", "0138", "0156", "00A4", "0128", "013B", "00A7", "00A8", "0160", "0112", "0122", "0166", "00AD", "017D", "00AF", 
    "00B0", "0105", "02DB", "0157", "00B4", "0129", "013C", "02C7", "00B8", "0161", "0113", "0123", "0167", "014A", "017E", "014B", 
    "0100", "00C1", "00C2", "00C3", "00C4", "00C5", "00C6", "012E", "010C", "00C9", "0118", "00CB", "0116", "00CD", "00CE", "012A", 
    "0110", "0145", "014C", "0136", "00D4", "00D5", "00D6", "00D7", "00D8", "0172", "00DA", "00DB", "00DC", "0168", "016A", "00DF", 
    "0101", "00E1", "00E2", "00E3", "00E4", "00E5", "00E6", "012F", "010D", "00E9", "0119", "00EB", "0117", "00ED", "00EE", "012B", 
    "0111", "0146", "014D", "0137", "00F4", "00F5", "00F6", "00F7", "00F8", "0173", "00FA", "00FB", "00FC", "0169", "016B", "02D9");

@iso8859_5_to_unicode = (
    "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F",
    "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F",
    "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F",
    "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F",
    "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F",
    "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F",
    "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F",
    "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F",
    "0080", "0081", "0082", "0083", "0084", "0085", "0086", "0087", "0088", "0089", "008A", "008B", "008C", "008D", "008E", "008F", 
    "0090", "0091", "0092", "0093", "0094", "0095", "0096", "0097", "0098", "0099", "009A", "009B", "009C", "009D", "009E", "009F", 
    "00A0", "0401", "0402", "0403", "0404", "0405", "0406", "0407", "0408", "0409", "040A", "040B", "040C", "00AD", "040E", "040F", 
    "0410", "0411", "0412", "0413", "0414", "0415", "0416", "0417", "0418", "0419", "041A", "041B", "041C", "041D", "041E", "041F", 
    "0420", "0421", "0422", "0423", "0424", "0425", "0426", "0427", "0428", "0429", "042A", "042B", "042C", "042D", "042E", "042F", 
    "0430", "0431", "0432", "0433", "0434", "0435", "0436", "0437", "0438", "0439", "043A", "043B", "043C", "043D", "043E", "043F", 
    "0440", "0441", "0442", "0443", "0444", "0445", "0446", "0447", "0448", "0449", "044A", "044B", "044C", "044D", "044E", "044F", 
    "2116", "0451", "0452", "0453", "0454", "0455", "0456", "0457", "0458", "0459", "045A", "045B", "045C", "00A7", "045E", "045F");

@iso8859_6_to_unicode = (
    "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F",
    "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F",
    "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F",
    "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F",
    "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F",
    "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F",
    "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F",
    "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F",
    "0080", "0081", "0082", "0083", "0084", "0085", "0086", "0087", "0088", "0089", "008A", "008B", "008C", "008D", "008E", "008F", 
    "0090", "0091", "0092", "0093", "0094", "0095", "0096", "0097", "0098", "0099", "009A", "009B", "009C", "009D", "009E", "009F", 
    "00A0", "FFFE", "FFFE", "FFFE", "00A4", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "060C", "00AD", "FFFE", "FFFE", 
    "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "061B", "FFFE", "FFFE", "FFFE", "061F", 
    "FFFE", "0621", "0622", "0623", "0624", "0625", "0626", "0627", "0628", "0629", "062A", "062B", "062C", "062D", "062E", "062F", 
    "0630", "0631", "0632", "0633", "0634", "0635", "0636", "0637", "0638", "0639", "063A", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", 
    "0640", "0641", "0642", "0643", "0644", "0645", "0646", "0647", "0648", "0649", "064A", "064B", "064C", "064D", "064E", "064F", 
    "0650", "0651", "0652", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE");

@iso8859_7_to_unicode = (
    "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F",
    "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F",
    "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F",
    "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F",
    "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F",
    "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F",
    "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F",
    "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F",
    "0080", "0081", "0082", "0083", "0084", "0085", "0086", "0087", "0088", "0089", "008A", "008B", "008C", "008D", "008E", "008F", 
    "0090", "0091", "0092", "0093", "0094", "0095", "0096", "0097", "0098", "0099", "009A", "009B", "009C", "009D", "009E", "009F", 
    "00A0", "2018", "2019", "00A3", "20AC", "20AF", "00A6", "00A7", "00A8", "00A9", "037A", "00AB", "00AC", "00AD", "FFFE", "2015", 
    "00B0", "00B1", "00B2", "00B3", "0384", "0385", "0386", "00B7", "0388", "0389", "038A", "00BB", "038C", "00BD", "038E", "038F", 
    "0390", "0391", "0392", "0393", "0394", "0395", "0396", "0397", "0398", "0399", "039A", "039B", "039C", "039D", "039E", "039F", 
    "03A0", "03A1", "FFFE", "03A3", "03A4", "03A5", "03A6", "03A7", "03A8", "03A9", "03AA", "03AB", "03AC", "03AD", "03AE", "03AF", 
    "03B0", "03B1", "03B2", "03B3", "03B4", "03B5", "03B6", "03B7", "03B8", "03B9", "03BA", "03BB", "03BC", "03BD", "03BE", "03BF", 
    "03C0", "03C1", "03C2", "03C3", "03C4", "03C5", "03C6", "03C7", "03C8", "03C9", "03CA", "03CB", "03CC", "03CD", "03CE", "FFFE");

@iso8859_8_to_unicode = (
    "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F",
    "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F",
    "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F",
    "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F",
    "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F",
    "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F",
    "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F",
    "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F",
    "0080", "0081", "0082", "0083", "0084", "0085", "0086", "0087", "0088", "0089", "008A", "008B", "008C", "008D", "008E", "008F", 
    "0090", "0091", "0092", "0093", "0094", "0095", "0096", "0097", "0098", "0099", "009A", "009B", "009C", "009D", "009E", "009F", 
    "00A0", "FFFE", "00A2", "00A3", "00A4", "00A5", "00A6", "00A7", "00A8", "00A9", "00D7", "00AB", "00AC", "00AD", "00AE", "00AF", 
    "00B0", "00B1", "00B2", "00B3", "00B4", "00B5", "00B6", "00B7", "00B8", "00B9", "00F7", "00BB", "00BC", "00BD", "00BE", "FFFE", 
    "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", 
    "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "FFFE", "2017", 
    "05D0", "05D1", "05D2", "05D3", "05D4", "05D5", "05D6", "05D7", "05D8", "05D9", "05DA", "05DB", "05DC", "05DD", "05DE", "05DF", 
    "05E0", "05E1", "05E2", "05E3", "05E4", "05E5", "05E6", "05E7", "05E8", "05E9", "05EA", "FFFE", "FFFE", "200E", "200F", "FFFE");

@iso8859_9_to_unicode = (
    "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F",
    "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F",
    "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F",
    "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F",
    "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F",
    "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F",
    "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F",
    "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F",
    "0080", "0081", "0082", "0083", "0084", "0085", "0086", "0087", "0088", "0089", "008A", "008B", "008C", "008D", "008E", "008F", 
    "0090", "0091", "0092", "0093", "0094", "0095", "0096", "0097", "0098", "0099", "009A", "009B", "009C", "009D", "009E", "009F", 
    "00A0", "00A1", "00A2", "00A3", "00A4", "00A5", "00A6", "00A7", "00A8", "00A9", "00AA", "00AB", "00AC", "00AD", "00AE", "00AF", 
    "00B0", "00B1", "00B2", "00B3", "00B4", "00B5", "00B6", "00B7", "00B8", "00B9", "00BA", "00BB", "00BC", "00BD", "00BE", "00BF", 
    "00C0", "00C1", "00C2", "00C3", "00C4", "00C5", "00C6", "00C7", "00C8", "00C9", "00CA", "00CB", "00CC", "00CD", "00CE", "00CF", 
    "011E", "00D1", "00D2", "00D3", "00D4", "00D5", "00D6", "00D7", "00D8", "00D9", "00DA", "00DB", "00DC", "0130", "015E", "00DF", 
    "00E0", "00E1", "00E2", "00E3", "00E4", "00E5", "00E6", "00E7", "00E8", "00E9", "00EA", "00EB", "00EC", "00ED", "00EE", "00EF", 
    "011F", "00F1", "00F2", "00F3", "00F4", "00F5", "00F6", "00F7", "00F8", "00F9", "00FA", "00FB", "00FC", "0131", "015F", "00FF");

@iso8859_11_to_unicode = (
    "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F",
    "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F",
    "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F",
    "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F",
    "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F",
    "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F",
    "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F",
    "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F",
    "0080", "0081", "0082", "0083", "0084", "0085", "0086", "0087", "0088", "0089", "008A", "008B", "008C", "008D", "008E", "008F", 
    "0090", "0091", "0092", "0093", "0094", "0095", "0096", "0097", "0098", "0099", "009A", "009B", "009C", "009D", "009E", "009F", 
    "00A0", "0E01", "0E02", "0E03", "0E04", "0E05", "0E06", "0E07", "0E08", "0E09", "0E0A", "0E0B", "0E0C", "0E0D", "0E0E", "0E0F", 
    "0E10", "0E11", "0E12", "0E13", "0E14", "0E15", "0E16", "0E17", "0E18", "0E19", "0E1A", "0E1B", "0E1C", "0E1D", "0E1E", "0E1F", 
    "0E20", "0E21", "0E22", "0E23", "0E24", "0E25", "0E26", "0E27", "0E28", "0E29", "0E2A", "0E2B", "0E2C", "0E2D", "0E2E", "0E2F", 
    "0E30", "0E31", "0E32", "0E33", "0E34", "0E35", "0E36", "0E37", "0E38", "0E39", "0E3A", "FFFE", "FFFE", "FFFE", "FFFE", "0E3F", 
    "0E40", "0E41", "0E42", "0E43", "0E44", "0E45", "0E46", "0E47", "0E48", "0E49", "0E4A", "0E4B", "0E4C", "0E4D", "0E4E", "0E4F", 
    "0E50", "0E51", "0E52", "0E53", "0E54", "0E55", "0E56", "0E57", "0E58", "0E59", "0E5A", "0E5B", "FFFE", "FFFE", "FFFE", "FFFE");

@iso8859_15_to_unicode = (
    "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F",
    "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F",
    "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F",
    "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F",
    "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F",
    "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F",
    "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F",
    "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F",
    "0080", "0081", "0082", "0083", "0084", "0085", "0086", "0087", "0088", "0089", "008A", "008B", "008C", "008D", "008E", "008F", 
    "0090", "0091", "0092", "0093", "0094", "0095", "0096", "0097", "0098", "0099", "009A", "009B", "009C", "009D", "009E", "009F", 
    "00A0", "00A1", "00A2", "00A3", "20AC", "00A5", "0160", "00A7", "0161", "00A9", "00AA", "00AB", "00AC", "00AD", "00AE", "00AF", 
    "00B0", "00B1", "00B2", "00B3", "017D", "00B5", "00B6", "00B7", "017E", "00B9", "00BA", "00BB", "0152", "0153", "0178", "00BF", 
    "00C0", "00C1", "00C2", "00C3", "00C4", "00C5", "00C6", "00C7", "00C8", "00C9", "00CA", "00CB", "00CC", "00CD", "00CE", "00CF", 
    "00D0", "00D1", "00D2", "00D3", "00D4", "00D5", "00D6", "00D7", "00D8", "00D9", "00DA", "00DB", "00DC", "00DD", "00DE", "00DF", 
    "00E0", "00E1", "00E2", "00E3", "00E4", "00E5", "00E6", "00E7", "00E8", "00E9", "00EA", "00EB", "00EC", "00ED", "00EE", "00EF", 
    "00F0", "00F1", "00F2", "00F3", "00F4", "00F5", "00F6", "00F7", "00F8", "00F9", "00FA", "00FB", "00FC", "00FD", "00FE", "00FF");

sub unicode_to_utf8
{
  local($value) = @_;
  local($unicode, $result, $byte1, $byte2, $byte3);
  $unicode = hex($value);
  if ($unicode < 0x80)
  {
    $result = sprintf("%c", $unicode);
  }
  elsif ($unicode < 0x800)
  {
    $byte1 = ($unicode >> 6) | 192;
    $byte2 = ($unicode & 63) | 128;
    $result = sprintf("%c%c", $byte1, $byte2);
  }
  elsif ($unicode < 0x10000)
  {
    $byte1 = ($unicode >> 12) | 224;
    $byte2 = (($unicode >> 6) & 63) | 128;
    $byte3 = ($unicode & 63) | 128;
    $result = sprintf("%c%c%c", $byte1, $byte2, $byte3);
  }
  else
  {
    die "unsupported unicode code position: $unicode\n";
  }
  return $result;
}

sub iso8859_x_to_utf8
{
  local($value, $table) = @_;
  local($result) = "";
  local($rest, $char, $charval, $utf8);
  while($value =~ /[0-9A-F][0-9A-F]/)
  {
    ($rest, $char) = ($value =~ /^(.*)([0-9A-F][0-9A-F])$/);
    $value = $rest;
    $charval = $table->[hex($char)];
    $utf8 = &unicode_to_utf8($charval);
    $result = sprintf("%s%s", $result, $utf8);
  }
  return $result;
}

sub iso8859_2_to_utf8
{
  local($value) = @_;
  return &iso8859_x_to_utf8($value, \@iso8859_2_to_unicode);
}

sub iso8859_3_to_utf8
{
  local($value) = @_;
  return &iso8859_x_to_utf8($value, \@iso8859_3_to_unicode);
}

sub iso8859_4_to_utf8
{
  local($value) = @_;
  return &iso8859_x_to_utf8($value, \@iso8859_4_to_unicode);
}

sub iso8859_5_to_utf8
{
  local($value) = @_;
  return &iso8859_x_to_utf8($value, \@iso8859_5_to_unicode);
}

sub iso8859_6_to_utf8
{
  local($value) = @_;
  return &iso8859_x_to_utf8($value, \@iso8859_6_to_unicode);
}

sub iso8859_7_to_utf8
{
  local($value) = @_;
  return &iso8859_x_to_utf8($value, \@iso8859_7_to_unicode);
}

sub iso8859_8_to_utf8
{
  local($value) = @_;
  return &iso8859_x_to_utf8($value, \@iso8859_8_to_unicode);
}

sub iso8859_9_to_utf8
{
  local($value) = @_;
  return &iso8859_x_to_utf8($value, \@iso8859_9_to_unicode);
}

sub iso8859_11_to_utf8
{
  local($value) = @_;
  return &iso8859_x_to_utf8($value, \@iso8859_11_to_unicode);
}

sub iso8859_15_to_utf8
{
  local($value) = @_;
  return &iso8859_x_to_utf8($value, \@iso8859_15_to_unicode);
}

open(INFILE, "<$table") || die "cannot open '$table'\n";
$i = 0;
while (<INFILE>)
{
  chomp;
  if ($_ =~ /^0x[0-9A-F]+ = 0x[0-9A-F]+$/)
  {
    ($unicode[$i], $iso8859[$i]) = ($_ =~ /^0x([0-9A-F]+) = 0x([0-9A-F]+)$/);
    $i++;
  }
}
close(INFILE);

for ($j = 0; $j < $i; $j++)
{
  $utf = &unicode_to_utf8($unicode[$j]);
  if    ($map == 2) { $iso = &iso8859_2_to_utf8($iso8859[$j]); } 
  elsif ($map == 3) { $iso = &iso8859_3_to_utf8($iso8859[$j]); } 
  elsif ($map == 4) { $iso = &iso8859_4_to_utf8($iso8859[$j]); } 
  elsif ($map == 5) { $iso = &iso8859_5_to_utf8($iso8859[$j]); } 
  elsif ($map == 6) { $iso = &iso8859_6_to_utf8($iso8859[$j]); } 
  elsif ($map == 7) { $iso = &iso8859_7_to_utf8($iso8859[$j]); } 
  elsif ($map == 8) { $iso = &iso8859_8_to_utf8($iso8859[$j]); } 
  elsif ($map == 9) { $iso = &iso8859_9_to_utf8($iso8859[$j]); } 
  elsif ($map == 11) { $iso = &iso8859_11_to_utf8($iso8859[$j]); } 
  elsif ($map == 15) { $iso = &iso8859_15_to_utf8($iso8859[$j]); } 
  else { die "unsupported mapping table $map\n"; } 

  if ($iso8859[$j] =~ /......../)
  {
    # print unicode character that is mapped to a sequence of four ISO characters
    # So far, all "garbage" sequences were here
    printf("unicode $unicode[$j]: %s --> %s\n", $utf, $iso);
  }
  else
  {
    # print unicode character that is mapped to a sequence of 1-3 ISO characters
    printf("unicode $unicode[$j]: %s --> %s\n", $utf, $iso);
  }

}
exit 0;
